//Verification of Gibb's Phenomenon
// Approximation of symmetric rectangular pulse  defined as f(t)= 1 for 0<t<pi; -1 for pi<t<2pi using a sum of sinusoids
//f(t)=sint+(1/3)sin3t+(1/5)sin5t+...
//Windows 10
//Scilab 6.1.0
clear
clc
fs=input('Enter the sampling frequency:')
T=input('Enter the duration over which the f(t) is to be plotted:')
t=0:T/fs:T;
p=zeros(1,length(t));
q=p;
n=input('Enter the number of sinusoids:')
// This loop generates the symmetric recgtangular pulse 
for i=1:floor(length(t)/2)
    p(i)=1;
    p(i+floor((length(t)/2)))=-1;
end
//This loop generates the approximation of the symmetric rectangular pulse 
//using a set of mutually orthogonal sinusoidal functions 
for i=0:n-1
    k=1/(2*i+1);
for j=1:length(t)
    q(j)=(q(j)+(4/%pi)*k*sin((1/k)*t(j)));
end
end
plot(t,p,'r',t,q,'k','linewidth',3)
xgrid
mtlb_axis([0 max(t) min(p)-1 max(p)+1])
xtitle("Approxiamtion of Symmetric Pulse using sinusoids","Time","Amplitude")
xstring(t(floor(length(t)/2)),p(floor(length(t)/2)),[" Point of Discontinuity"])
legend(["Rectangular Pulse","Sinusoidal Approximation"])


//output test case
// sampling frequency:1000
// duration over which the f(t) is to be plotted:2*%pi
// number of sinusoids:3

//output test case
// sampling frequency:1000
// duration over which the f(t) is to be plotted:2*%pi
// number of sinusoids:50
